(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     29016,        691]
NotebookOptionsPosition[     27473,        645]
NotebookOutlinePosition[     27859,        662]
CellTagsIndexPosition[     27816,        659]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "x"}], "-", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f3", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "-", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", "3"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"f1", ",", "f2", ",", "f3", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "5"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.714232760610136*^9, 3.714232799177779*^9}, {
   3.714233846719922*^9, 3.7142338478869963`*^9}, {3.714234030646995*^9, 
   3.714234031933969*^9}, {3.714234075949188*^9, 3.714234103866987*^9}, {
   3.7142341624725733`*^9, 3.7142341710398493`*^9}, {3.714234208310499*^9, 
   3.714234217773719*^9}, {3.714234300211459*^9, 3.7142344016619883`*^9}, {
   3.714234454267857*^9, 3.714234499601831*^9}, 3.714234536761671*^9, {
   3.714234606285246*^9, 3.714234608437099*^9}, {3.714234638563953*^9, 
   3.714234652445126*^9}, {3.714234765119285*^9, 3.714234833674604*^9}, {
   3.714234888953681*^9, 
   3.7142349300942993`*^9}},ExpressionUUID->"bdb69dd3-63cd-4d81-89f6-\
06ffc47c2522"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwlzXswnFccxvG1a/cVcd23iQgSkrqMKJ1kXELrHNaYDKLLlFxsI665MHFt
tUuNJhNkQqQVVW1cSwmVtHFZuTTnxIiUSImKZBAjBk1d32XtYu3q2zl/vPOZ
OfP8vq9NdFJoHJfD4Rxlv//tK7q8sbVFYSINJVq96EdaChNpOJ9Y0JOloTCR
hoYBxT+sb1CYSMNg3Wq3lVUKE2k48OXD1Jk5ChNp+DJqZbbvFYWJNBw/FDVa
dofCRBq6rl6UJh+nMJGGFGPxxJCiMJGGC7tTHotkAkwUwl0xBlntpwWYKISP
pvZMLhkLMFEIb13KEMR38DHRFNaHFoylR/Mx0RRaR+w6FSDkY6IpHM+ZLZc8
0MVEE2g2ceiK63ldTDSBsUmH7ep362KiCVRaXP4mrIuH5931eU35xpDHPZLf
m8bDAt3rJiX/GMEwfsjRLEsebtSv+XHNwwje99jZ1d3NxekpTvmFhYbwp7rQ
mVdfcLFbYF3fnQUDiF1edttac3FOZGNhIDSAUSt/hXr26+DOmfK69Irt0H/I
qPxqhg4uaLDyNFvSh2Bav+xzGx2c3bvj4JyvPmxxyYZ2Lzg4PnIzJ6hmG0ws
df+FlnLwa+ekIHuFHqzyOCt76sDBMGXgQlGIHuynGxUOd7cQkYLvGGOVF38L
ESmogrHisRgtIgrg9Wd+dspWDSLyobi9PNJnmwYR+VDw3vSS+blNRNSF/r92
bCY8UCMiD2bJpKcDzdWIyIMj+9rsJdINROTCx39mJsw8X0dEHVj59kOB1mkd
EXWgwDXVqih7DRE5MEZdfbV5VIW6lSKzCNkWeGcT8JnGS4UGRDfub2RogfJi
dlP3NSWa52vCC600QB1eLbZaWEXKZt9qzxE1uBInTl34eBUJn1VNjWRuAO+h
DNXitwqU1bC0+Gb/OphtK/z7a/kKGkqwqFdPqsDeQRenXNEK8q6NPG6QpwSB
UXjUonoZfd+ZI3P3XQUV4p7FSZ1l9FH1d2+e8BQgU3oqe3+YHCkVDzf9G5dB
sNlkrLyFQTedu3omz8hBarS00uZ3Bk11KbxF0XJQ2iwcCbnNIOcI29afJXIw
IRJ9creBQTgvtyI2hN0n1x5OK2f3E0fSZjzloKQn3mg1l0GOxc8tZw3lYCxz
TrZ2gkEdquEk9j+A8/TSssMxBnGuUdNsF9gKLT848SmDAt73OMl2wYWGoJp7
wQwaE5f5sV2wNdRcIBUxSHsrwpztgn3OyVGbTgzyk0x0sl3g/5XeTSdHBhUs
m3iwHZDQVTUssWfQcL5PM9sBrSdfBP5hw6CzbTWlbAf45x10y97J7o3iEtkO
OD/Ym3ybZtBQbclb9g4UWcU0jZswaI9Xdzh7B163FFuD7Qz67Yy9D3sHNrUH
IpL0GLSmOdbO7oB1QFdJJZ9B8Eb+AXYH/EokA/1cBuU73qti38G5CYU+h8Og
QfzvDlbwH4jocdE=
        "]]},
      Annotation[#, "Charting`Private`Tag$5459#1"]& ]}, {}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQrWcv9ur///f7GcDgg31Q+9nVxvEIfvn5ltz0fe/g
/CtXuF8dTHwL58seyBcxl3kD52/NPsLKf/cVnJ/QY/jhZtNLOP/HpOqO/fYv
4PzFfPckZzx8BufP8TIsutz5FM5vykms0PR8AudXM68qL3r7CM5PbDivcm3F
Qzh/6t6nM+ZkPYDzd93X4FmjdA/OVxZwcAqZdxvO36TVkfXo8Q04//7RjQpm
Ztfg/Kc6U432b7sM5wvWrTTTY7wI5+uYvddZ+vkMnN/s8vbCzorjcL5oyLoJ
keKHEPZ9O8p/QmUXnL/09tPely3r4PzYQJktt5OnwPk7uaqvHiqdbA/jmz5i
lGuMWA/nK3/Y/dPq0E4433PxzbN+EYfgfFdfIeavW4/D+f3x1xsMtp+B84/7
yfIGCF2E898qitZdmnUZzi8t0U7sF7sG51+/IxCUduIGnJ9QafOc3ec2nH9Y
27zrMOs9OF+Nc8+LJR4P4HzZPdmurB0P4XyGX0wrix49gvO/B+6NO6r6BM6/
bRIvrdryFM4vCBcQVLrzDM6XnPIkgkX2BZy/LnrB8s8VL+H8cNt6jxN7X8H5
G+Nylaz+vIbzf3A5M+8MfQvnB120NpOd8Q7Od+DQnMDn8x7Oh+YXOB8AsoAY
Yg==
        "]]},
      Annotation[#, "Charting`Private`Tag$5500#1"]& ]}, {}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwtyn1M1HUcwPF74O4LB8JxXw6DFEKDIVISD5pifD5cDIUikbhoNyE9M0VK
BGawIYIKQWs8qMiYILHhSNDJEDSbiowobgRHhAWkliPjQQh+x8Mhd8Dl7ff9
473XP28vbWrcIZFAIIh5mdXkp/MygYCD39onlFZ3i6dDz4o4KJM+zpRKOPD1
Gfvcauz7+mEHGQejKcN6qz2DNy+7uXDw6eL981Z109neQb4c7HcsdLfavs4x
5LNYDj7a6eZn9XpWYHxPLQcRle9EWS0KyD5fGW6ACqVJ5rnHAP6b55VhNbNg
8NSdeGYwwAiUTer+mQPv7vU5WedmIbo81MRtWIC+7WPkQtgc1GTonXxyjHB2
a0foa0/nQPpFfia2L8KNF/K5oNJ52GfwGj3ssQTNmrFI19AF0N7SF/t/aYK2
qL53Ux4twMkLNYV/3DZD+KpfZ+TXRjizrC4qVqyAHir/K9+8CNW5AY82JaxC
sFdxS3P3IhxRuR8+eNECct3CcnzmC6YAjebUmaOvLAGvEOMWEg+RriXgFWJh
yUBmeroJeEX4c6smKFZhBl4xZteq01sfmIFXjDvctJpvDiwDrw2mJoz8NC5f
AV4J5oQ873W5vwK8ErxYK85tSVwFXilu7C9rGbK3AC/BuyVbzh2/YQFegkpj
Y8GkjwD9ptT2gzG2WESybLQ5ApQ7cbadJlvM+7t30FkvQMGDqqaN1XYYfOnJ
VL63EI8E3x22e0+GD19/K/aTbCFejdLWthlluHRijW3GL0KcnXSXj1bY43BD
nTB6gwhvfrhLXB7hgGFXOvZoMkR4cnfBt62jDlh6zHuqv0OEHk+ih+oK1mDV
q6puBzcxbt2WX+4W6Ij+pWPLecli/Nijb0k44IhZ/0am3WkXI9ddPHL8tBNG
ibbs2KSwYcqRzGj2CrU2TDnmtWFj9R0bphxPxTclpNlJmM64rXcw0u6AhOmM
j5UR+bbfS5jOKPXe7hpOpEwFTrqOT+xMkjIVqO7zVKQ3SZkKvJ5QVeRokTIV
2NbxKx5TEyZF9XxJDKknTIodelVA6neESTGgwagYvEqYFB2SkobqrxEmxc6u
Nw5GNhMmxcCqnqyCe4RJUa6SXREPECbFU+vavkp5SJgUp4xpyQO/EyZF3bXh
N+uGCJNirrLhB9VfhElxenxX3+kJwqS470dz88RzwqTYfbmpfO8UYVKsj1ur
8ZohTIqJ90aftc8T5su/4lKXr5EwKb6d9kFj2SJhUnTxuZ2630SYFM8Ijsbp
zIRJkftzfUjACmFSTLrVv7ZylTAp9pQWmCwWwqT4P/CRKM8=
        "]]},
      Annotation[#, "Charting`Private`Tag$5541#1"]& ]}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-3, 3}, {0, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.714234521153378*^9, 3.7142346561004353`*^9, 
  3.714234859143057*^9, 
  3.714234939025666*^9},ExpressionUUID->"cb84f213-dd5e-48a7-911a-\
8a71e9edee68"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", "^", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.714236437622085*^9, 
  3.714236461937541*^9}},ExpressionUUID->"40dc4cbd-751a-45e9-b849-\
8bc359d0939a"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwBYQOe/CFib1JlAgAAADUAAAACAAAAfedN8v//E8BU9vglAACgP+Z7FvXb
/BPAyTWjprcIoD9OEN/3t/kTwHynBudzEaA/IDlw/W/zE8DK2FOx+iKgP8KK
kgjg5hPAn4/RtEFGoD8ILtcewM0TwJrRVcK3jaA/lHRgS4CbE8Ay/QWbViCh
P6sBc6QANxPAtdorOvlUoj8FZUcyGV0SwM6ynFTXPqU/E9jFbKKREcAUKkW1
8GGoP1LDmmMpyhDALiTJN0zoqz977z1skOMPwB3MxlqcJ7A/uHeaaq9PDsDn
v6wwYYWyP06SVSD+mQzA3aesN3J6tT9Hnb1OSOwKwJX2Vxox17g/psd51nNb
CcBubNudJHO8P16ElBXPqAfA23uWc6x6wD9+YAOuCxMGwPDocOOx58I/AC0f
v0OFBMAfSbXcJ6HFP9qLmYer1QLAPqLW7gsIyT8cCmip9EIBwADG0DvHr8w/
azUqBdsc/7+zM/N4gqDQP2M33qjDw/u/GKte9uU40z8qeDr/bqT4v0P7zEKn
AdY/od1TxHlB9b971u+D4XvZP+eBFTxHGPK/Hf01CEw53T+6lShF6Fbtvyyp
4qH78uA/MOnZ9C+d5r/QqC3hcZvjP0S62wn9VuC/u9pHxCN25j9wqa/4ERPT
vxUTvMEFB+o/VmYjodJ8ub/shjamu93tP8fM2YozU7g/Gkxf7toW8T86LcGy
UJfTP51RoucryPM/AnYV3GQZ4D9VVRQWFK32PwcMUIFi7uY//b7bgflK+j+D
4NZDcqPtPxrxABp+Z/4/sJuGUH7y8T9k+hKehWgBQG+iZBDkVvU/yLyLPP8p
BEBeapodh4H4P6KFAsD9IAdAiVF2OTOc+z8C37C2QnUKQAQUleZ/+v4/zpqa
OWOdDkDXy4XwhA8BQDyt/i8+ihFAVXtiNprDAkCuPE/LX1QUQGwL6yLOWgRA
P5GBYWhVF0Afq8aWBuoFQLRpPdSUtRpAe7hDUw+bB0CUewVx3OweQHCmbLY2
LwlAJIgTRqu6IUAMAjdiLuUKQKxvy6rbjyRARW1UlSqTDECWWhducsgnQBi5
HW9FJA5AnxsopLU9K0CScoiRMNcPQGS/i7Kgjy9AUoZPLZ22EEDi3WHT7xoy
QAN7rV2ADBFAI8zV+mQ7M0BjRpoW
       "]]},
     Annotation[#, "Charting`Private`Tag$5872#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-5, 5}, {0., 19.232009579846032`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.714236463297865*^9},ExpressionUUID->"0bacfebc-3a62-4d4f-a10d-\
2eb44de5c5a4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "^", "x"}], ",", 
     RowBox[{".5", "^", "x"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7142364935549393`*^9, 3.714236495221054*^9}, {
  3.714236539223276*^9, 3.714236601499498*^9}, {3.714236644547187*^9, 
  3.714236653051017*^9}, {3.714236704928439*^9, 
  3.7142367368216057`*^9}},ExpressionUUID->"adb9b85d-81dd-434e-9501-\
b61326161560"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwBcQOO/CFib1JlAgAAADYAAAACAAAAfedN8v//E8BU9vglAACgP+Z7FvXb
/BPAyTWjprcIoD9OEN/3t/kTwHynBudzEaA/IDlw/W/zE8DK2FOx+iKgP8KK
kgjg5hPAn4/RtEFGoD8ILtcewM0TwJrRVcK3jaA/lHRgS4CbE8Ay/QWbViCh
P6sBc6QANxPAtdorOvlUoj8FZUcyGV0SwM6ynFTXPqU/E9jFbKKREcAUKkW1
8GGoP1LDmmMpyhDALiTJN0zoqz977z1skOMPwB3MxlqcJ7A/uHeaaq9PDsDn
v6wwYYWyP06SVSD+mQzA3aesN3J6tT9Hnb1OSOwKwJX2Vxox17g/psd51nNb
CcBubNudJHO8P16ElBXPqAfA23uWc6x6wD9+YAOuCxMGwPDocOOx58I/AC0f
v0OFBMAfSbXcJ6HFP9qLmYer1QLAPqLW7gsIyT8cCmip9EIBwADG0DvHr8w/
azUqBdsc/7+zM/N4gqDQP2M33qjDw/u/GKte9uU40z8qeDr/bqT4v0P7zEKn
AdY/od1TxHlB9b971u+D4XvZP+eBFTxHGPK/Hf01CEw53T+6lShF6Fbtvyyp
4qH78uA/MOnZ9C+d5r/QqC3hcZvjP0S62wn9VuC/u9pHxCN25j9wqa/4ERPT
vxUTvMEFB+o/VmYjodJ8ub/shjamu93tP8fM2YozU7g/Gkxf7toW8T86LcGy
UJfTP51RoucryPM/AnYV3GQZ4D9VVRQWFK32PwcMUIFi7uY//b7bgflK+j+D
4NZDcqPtPxrxABp+Z/4/sJuGUH7y8T9k+hKehWgBQG+iZBDkVvU/yLyLPP8p
BEBeapodh4H4P6KFAsD9IAdAiVF2OTOc+z8C37C2QnUKQAQUleZ/+v4/zpqa
OWOdDkDXy4XwhA8BQDyt/i8+ihFAVXtiNprDAkCuPE/LX1QUQGwL6yLOWgRA
P5GBYWhVF0Afq8aWBuoFQLRpPdSUtRpAe7hDUw+bB0CUewVx3OweQHCmbLY2
LwlAJIgTRqu6IUAMAjdiLuUKQKxvy6rbjyRARW1UlSqTDECWWhducsgnQBi5
HW9FJA5AnxsopLU9K0CScoiRMNcPQGS/i7Kgjy9AUoZPLZ22EEDi3WHT7xoy
QCpbhFWkfRFAjp1zBWK3NEDdz8Hx5tQRQAUUT7mvCDZAV2ahmQ==
       "]]},
     Annotation[#, "Charting`Private`Tag$7848#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwBYQSe+yFib1JlAgAAAEUAAAACAAAASxlBnJLVEcAFFE+5rwg2QBPYxWyi
kRHAl3JvLaT/NEBSw5pjKcoQwAPd61msWDJAe+89bJDjD8BfUfKJibEvQLh3
mmqvTw7A8sGXKu+kK0BOklUg/pkMwMBfP6aH1idAR529TkjsCsASVA9Mhpwk
QKbHedZzWwnAyTy43iL/IUBehJQVz6gHwGKT5n/JER9AfmADrgsTBsC9/2DE
KxUbQAAtH79DhQTA/xzhLN6rF0Dai5mHq9UCwHXj4+ZLdBRAHApoqfRCAcA1
yW64GNkRQGs1KgXbHP+/E7rNCBbLDkBjN96ow8P7v64ANfTCogpAKng6/26k
+L9JNL7WEUQHQKHdU8R5QfW/Rw2L5FIXBEDngRU8Rxjyv0cT+uIbhQFAupUo
RehW7b/dOACKPzX+PzDp2fQvnea/VtGSmuMc+j9EutsJ/Vbgv8k/w15py/Y/
cKmv+BET07+xwLvl6qvzP1ZmI6HSfLm/btsX7aUk8T/HzNmKM1O4P81BTpvW
9e0/Oi3BslCX0z+RkE4o2eHpPwJ2FdxkGeA/ANOIjy+U5j8HDFCBYu7mP67j
X+gTeeM/g+DWQ3Kj7T8LcOBF+dbgP7CbhlB+8vE/+LkObklp3T9vomQQ5Fb1
P3Ebl/pHZNk/XmqaHYeB+D/IjNWOByPWP4lRdjkznPs/aDt9n/RZ0z8EFJXm
f/r+P3yg4CFUudA/18uF8IQPAUCMQsU+vjDNP1V7YjaawwJAlpreF1ovyT9s
C+sizloEQGlDaCxN8cU/H6vGlgbqBUBOuU2dWivDP3u4Q1MPmwdA1s+2uFmO
wD9wpmy2Ni8JQB/U/esC4bw/DAI3Yi7lCkBRuFR6fua4P0VtVJUqkwxAyre4
EiqHtT8YuR1vRSQOQKuRfruPy7I/knKIkTDXD0BuEFez9ziwP1KGTy2dthBA
LDadVXVHrD8qW4RVpH0RQE/9cYv8tqg/1uYJopNVEkCRT0B8mlqlP85i5UES
HxNAujxKSJ2hoj/hBKf4lSITQEkWhfRHlqI/9KZorxkmE0DR/ZuF+YqiPxnr
6xwhLRNAS02aRXF0oj9kc/L3LzsTQFvODciyR6I/+oP/rU1XE0D03MA4eu+h
PyalGRqJjxNA5q+DW/5DoT85R9vQDJMTQD9U07N9OaE/TOmch5CWE0A+BqFv
Ay+hP3EtIPWXnRNAuH8tAiIaoT+8tSbQpqsTQBZRzyar8KA/UsYzhsTHE0Aa
rwgU6p6gP2Vo9TxIyxNAwp0D182UoD94Crfzy84TQHNkZ8C3iqA/nU46YdPV
E0D173T3nXagP+jWQDzi4xNAilt3jrNOoD/6eALzZecTQG5leBzIRKA/DRvE
qenqE0C8EDSz4jqgPzJfRxfx8RNAbu4u7CknoD9FAQnOdPUTQM6FHYdWHaA/
WKPKhPj4E0DihSUciROgP2pFjDt8/BNArS6kp8EJoD99503y//8TQFT2+CUA
AKA/IaEJwg==
       "]]},
     Annotation[#, "Charting`Private`Tag$7848#2"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-5, 5}, {0., 22.03393133335705}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.714236584446948*^9, 3.714236602078003*^9}, {
   3.714236648382148*^9, 3.714236653506268*^9}, 3.714236706851639*^9, 
   3.714236759955579*^9},ExpressionUUID->"59aecd2b-339a-4693-9906-\
5455f09d855a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "+", "6"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", "2"}], ")"}], "x"}], "-", "3"}], ",", "x"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "}"}]}]}], "]"}]], "Input",\

 CellChangeTimes->{{3.714237740086774*^9, 
  3.714237820144607*^9}},ExpressionUUID->"2d8fdd8f-d8fc-4a04-9fc6-\
50553a91f5fd"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBmIQDQEKByC0yoHq97Y5Ex7LQ2nlAzvKZ2Wt95eD0koH
/CaFKvybKQOlFQ64z93r5/FG6kCfVfXcCTdkDyw7XnmtOFrygE//5zXPt0kd
iGuZInp+hfiBPRya2vMCxQ/UJTCv4xYWO/DnAFuMuJrIAQZd+f3OrUA6yq6u
nUvwwK3ume2rrwodyNBPk1sXxn1Ahitj5RcnwQMFGguWXuJmPZBtqsV6W4b/
wJqrK0Ryiv/sTza/t+LwYe4DErs/usnKvduvVWH1P28JxwEHVv/n93uP7F94
N/hIpSPrgR9CiXcNvzy1f94oauMuwXQg5cdK/sfzvtvvmqrh+iLs7363rOu7
xFcyORi8vPlFf+63/RfE1LgvJHE6uOy6zfk37MP+Pa4q35hW8jsUrFz/Q1D4
8f4lolcara2FHcLSlBdeqjm5f/bJt1eNMsQcjp+52WUcfML+zJy1Fsatkg5W
ugc3BUx/bO/nvUHnylMZB6Yy0Tspkh/sG2JZzSPZFBzYeQIak959s2diDlkw
Y7eiQ/ODa85Fi//aK+74OuFOhrLDfwiwh8aPAwAAPcg4
       "]]},
     Annotation[#, "Charting`Private`Tag$8864#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwt1Hs01GkcBvChZnMrZszEMPzwWpY9UtmlUO8bWSokRW2W7LjkSKk4k6KW
01BpLcqkTLMnksuqdPak26n9fYtybXK2sKhVRiJtzbhEzpjftmfnj+d8/n2e
fx57UWp4gj6LxQr5nP88/CZknGEQ/C8Fw5mLp/o1SCcFoWYD0zc/IZ0U2K3c
O5c6gXRS8CD/lMHLYaSTAoMlPbbwGOmkoCQ9dkO2DOmkoE4vrZLlhXRSwE4I
XC6IdtBpC+Z/PUypKLbXaQPhjWVxLm12OoWQ+WFVSpGSgj+mbT1b1NZw60BZ
cv1GW3juE9LQ42wNoaci7LTnhODc6mrGBFtBoPxeaNA7K6hUxDg7igVQ1Xyw
Oy1KAE+VvmO3r1hCjKSE/6TGAtz92vJ3PrOAI7HzrhqbLwZ8Ta8n19ACWG4U
7Z/Lg+wzhQPlfouh7+S5Y3VdXPjnYUdjVzIfhEZJtZN+HFjEvr7lUDkPdn3r
yu4XmkJUwfr7ns3mEOf1d01jozH0Fni9Vam44JrhzeypNACjXxW0tQsXyl9s
bjq4hg1J07x9MWEceJPD9w201IdDsewnnDwzuCP9KmAkco7e8+V6zp0IU1g6
2jvpLv9IBx/ynNtQvRDW3uk3nItU0cXvxX403wT21tbPcMyV9JIpPhaJjCAy
EZX/mdVKe1gbSofbDaC5ozffY3MLLltWG5e4agF4u93/PaxUib/vqx7lF7BB
X8x/Hi9Q4eyK2ZaqT/NggUlYjuj9R6zV1O3YuVYfjr7s9t9/cQ4PBBqlolIW
XJPlhR0Z1yNh8QfrcxZq6dSKeLOhSDYpjpZ9sK6dpWOSy2yO5RiQCmnCYMaR
afrEJvFKj/PG5MDVE4864ibp+Tzp8E+zi4hmLFmQzVbTPe25Kokph1R2jqx6
d3+MjsgUeZY1csllrtipVD1EpxiPOSi288iFyuqRX1xe0FTdozNfvOUTg+q2
de31nXTmLf/NpjILQl5x3L/2raX3VqXc8HQXENbOtsRdEw+wib6XaMlrKxJr
douT5tKDA3ZvkbqeFhJew6aI34IHseVtm9QAR1sSOyS+yy8ewaf2Hy9e2kOR
oDb77x788AGH5210k9+wI0GC1Q3pfePYNUoSUXnYntSkcCKLP07h7mHDitMR
DmSbzPl4aOQnrBC9XsOlEFlxUrpgXZYGv5pfPSN1QERifn5wa74GT1Yl1Quc
EOmUVdxLPKvBgrExob0bIvGX69Mk1zU4Pm182t0HkaLHrQP0Ow2ePcpcCdmK
yIip9qZn9Bx2uiSwOlGIyNmSxCTH1Vq8MrC/0+Q0IkPC3f4ewVocPHr+WNEZ
RJZeSrP1267F+9zspkrliDQ1ZD/bIdbiuw1OnVV1iKi6y4jsqhaHP/LIa2pG
n/c9seRSDE5ImvINakekpLxrws6NwRlGNyfaFYi8dHmucPdhsDzU+8enXYik
e49KQrYyeKSb+A4qEbkQNU99vJDBsxn6EwlvPvdVGnaUyhm80LqpdvQtIt+k
mFVX1TF4+Y5AC7UakZYsm+imZgYH6Bkq0qcQ4bEdVzztYvC2i22SmRlEYgtc
zQeVDE4O+NknS4NIDX/Ze5Wawbr/IpNyr1aGYfC/0q5ZXA==
       "]]},
     Annotation[#, "Charting`Private`Tag$8864#2"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxF1OlPEnAcgHEkKRTLExVDOWyu2FCnS+fR0ozhVqJhUMtlhtKcUZg606GW
EzWtLRXRifLCI9KxsrWl5mpamJYWuZqY0WGReLXyQslJVFt8fy+eff6DhyYQ
c4VYDAaT8Ld/Fs8mrFit/oM2jRJPk34LyXH5vNH7C0mNyLaIV5FPq+vw00Yk
PnDSb/AVsj4v7cjVZqTaLrcDE47ECdkhpNN00P3dM1FbLQ3kahTp+0apoOTn
AVGNgQL2XVZkdSf6gZw6HvV3ExlkKx9z4r/7gKqRQl1uCglMldYTX3d6gSVp
2+4S3D1BDJMyEFfuAb6/3lSpnnADyY6ZXWuHXMHz+xk4PdkZTA//1KnREEBG
QaT1YgcebP2YPFQYiwNnS4nRbG8s2C/fy5rjWwZsBs9PrQUp18HD/XoHC38J
zO7qNru6G0D+Of/WN0UvwJGXU9Whyc8P2oxkPrmf1GgAsfnEDxmkJXCHU1Kp
4Mc6WDati8tpt4D3miuSSlbsYmyK2zJcvvFxYGqWwreyFA9WHcuPCG0hgPYe
cuOVzV3g5Fj5ktTZFeRJBGEKjRsoIizStac8QIp6uGH7AhGU9MUlOzd7gdkq
UU9YEAl0woYLAmd8QNaF43KGjAx6P/QVs/b4gXU512qDJykgtyKRqeyhgowU
Ka+jmAbqjA5tMh4d1ApmYt0o/uAX+9tmOR25psrsJgUgSYuLZBoTmZG7shEU
hdwss95JOIEMuEXyqbqJjGDrx51kyKPzLZU1DchLTKqpUYl89CBgXKVGcodD
K4ZGkMJMU3T8GLLAsXd1TItUciLPvp1Azulior8akJsF2FXhLHLn7qGu+QVk
yBm21/IykmXnoM0zIU+2j0rNZmQW60ZU0Rby/7fAPwoONb0=
       "]]},
     Annotation[#, "Charting`Private`Tag$8864#3"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-10, 10}, {-10, 10}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.7142377688963013`*^9, 
  3.714237821338965*^9}},ExpressionUUID->"835851f0-1dd4-47fd-8f4f-\
ac145a2b747d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "0"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7142383632113647`*^9, 3.7142383747752657`*^9}, {
  3.714238434374325*^9, 3.714238435276462*^9}, {3.714238486932068*^9, 
  3.714238490866498*^9}, {3.714238565623527*^9, 
  3.714238574118422*^9}},ExpressionUUID->"8a334360-72a2-4813-ab5b-\
66fd61cba259"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVzHk4lAkABnDkqmQwjhKRM7asmzbyJaXSsjurdJGzQrq2KB2rlrZDuSVM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       "]]},
     Annotation[#, "Charting`Private`Tag$10679#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-5, 0}, {-0.9999999999999896, 23.999998979591844`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.714238491355063*^9, {3.7142385667669973`*^9, 
   3.7142385743191843`*^9}},ExpressionUUID->"c83cc446-d77a-4a50-bac7-\
d3284453e028"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.7142394354375343`*^9, 
  3.714239436816229*^9}},ExpressionUUID->"eca21469-fc03-477c-823a-\
cc2fd7b23655"]
},
WindowSize->{808, 865},
WindowMargins->{{Automatic, 117}, {-53, Automatic}},
Magnification:>2. Inherited,
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 27, \
2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 1886, 52, 187, "Input", "ExpressionUUID" -> \
"bdb69dd3-63cd-4d81-89f6-06ffc47c2522"],
Cell[2469, 76, 5482, 113, 505, "Output", "ExpressionUUID" -> \
"cb84f213-dd5e-48a7-911a-8a71e9edee68"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7988, 194, 310, 9, 63, "Input", "ExpressionUUID" -> \
"40dc4cbd-751a-45e9-b849-8bc359d0939a"],
Cell[8301, 205, 2680, 63, 510, "Output", "ExpressionUUID" -> \
"0bacfebc-3a62-4d4f-a10d-2eb44de5c5a4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11018, 273, 536, 14, 63, "Input", "ExpressionUUID" -> \
"adb9b85d-81dd-434e-9501-b61326161560"],
Cell[11557, 289, 4556, 95, 505, "Output", "ExpressionUUID" -> \
"59aecd2b-339a-4693-9906-5455f09d855a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16150, 389, 767, 27, 146, "Input", "ExpressionUUID" -> \
"2d8fdd8f-d8fc-4a04-9fc6-50553a91f5fd"],
Cell[16920, 418, 4962, 101, 403, "Output", "ExpressionUUID" -> \
"835851f0-1dd4-47fd-8f4f-ac145a2b747d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21919, 524, 483, 12, 63, "Input", "ExpressionUUID" -> \
"8a334360-72a2-4813-ab5b-66fd61cba259"],
Cell[22405, 538, 4895, 99, 404, "Output", "ExpressionUUID" -> \
"c83cc446-d77a-4a50-bac7-d3284453e028"]
}, Open  ]],
Cell[27315, 640, 154, 3, 63, "Input", "ExpressionUUID" -> \
"819abbd0-cf27-4077-a692-10800286d894"]
}
]
*)

